/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;

public class RemoveVTerm {
    private static final int NUM_VALID_PARMS = 3;
    private String m_managedSystem;
    private String m_partitionName;
    private String m_partitionID;
    private static final String vts_port = "9735";
    private static final String session_id = "0";
    private static final String delete_flag = "2";
    private PrintStream m_outStream;
    private boolean m_writeStatus;
    private HashMap m_validParms = new HashMap(7, 0.5f);
    private PIHSCClientObjectFactory m_factory = null;
    private PIHSCCECClient m_CECClient = null;
    private PIHSCLPARClient m_LPARClient = null;
    private String m_hostName = null;

    private RemoveVTerm(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_outStream = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-p", null);
        this.m_validParms.put("--id", null);
    }

    private void checkParameters() throws PIHscClientException {
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            String[] stringArray = new String[]{"-m"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (!(this.m_partitionName != null && this.m_partitionName.length() != 0 || this.m_partitionID != null && this.m_partitionID.length() != 0)) {
            String[] stringArray = new String[]{"-p | --id"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_partitionID != null && this.m_partitionName != null) {
            String[] stringArray = new String[]{"[-p | --id]"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
        int n = pICECDataBean.getCecState().intValue();
        if (n != 17 && n != 1) {
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
        }
        this.m_LPARClient = this.m_partitionName != null ? this.m_factory.createLPARClient(this.m_managedSystem, this.m_partitionName, false) : this.m_factory.createLPARClient(this.m_managedSystem, this.m_partitionID, true);
        if (this.m_LPARClient == null) {
            if (this.m_partitionName != null) {
                String[] stringArray = new String[]{this.m_partitionName};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
            }
            String[] stringArray = new String[]{this.m_partitionID};
            throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray, null);
        }
    }

    private void performCommand(PrintStream printStream) throws PIHscClientException {
        try {
            this.m_hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_factory = PIHSCClientObjectFactory.getInstance(this.m_hostName, null);
        this.checkParameters();
        String string = this.m_CECClient.getIntName();
        String string2 = this.m_LPARClient.getIntName();
        String string3 = this.m_LPARClient.getIntName();
        if (string2.indexOf(42) == -1) {
            string2 = string2 + "*" + string;
        }
        String string4 = this.m_hostName + " " + vts_port + " " + string2 + " " + session_id + " " + string3 + " " + delete_flag;
        printStream.print('\u0000');
        printStream.println(string4);
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_partitionName = (String)hashMap.get("-p");
        this.m_partitionID = (String)hashMap.get("--id");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "RMVTERM_HELP_2"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        RemoveVTerm removeVTerm = new RemoveVTerm(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, removeVTerm.m_validParms);
            removeVTerm.mapParameters(hashMap);
            removeVTerm.performCommand(printStream);
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

